// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, FormButtonType, FormChoiceType, FormFieldType, FormTextType};
#[cfg(feature = "v21_12")]
#[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
use crate::{SignatureInfo, SignatureValidationFlags};
#[cfg(feature = "v21_12")]
#[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
use glib::prelude::*;
use glib::translate::*;
#[cfg(feature = "v21_12")]
#[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "PopplerFormField")]
    pub struct FormField(Object<ffi::PopplerFormField>);

    match fn {
        type_ => || ffi::poppler_form_field_get_type(),
    }
}

impl FormField {
    #[doc(alias = "poppler_form_field_button_get_button_type")]
    pub fn button_get_button_type(&self) -> FormButtonType {
        unsafe {
            from_glib(ffi::poppler_form_field_button_get_button_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_button_get_state")]
    pub fn button_get_state(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_button_get_state(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_button_set_state")]
    pub fn button_set_state(&self, state: bool) {
        unsafe {
            ffi::poppler_form_field_button_set_state(self.to_glib_none().0, state.into_glib());
        }
    }

    #[doc(alias = "poppler_form_field_choice_can_select_multiple")]
    pub fn choice_can_select_multiple(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_can_select_multiple(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_commit_on_change")]
    pub fn choice_commit_on_change(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_commit_on_change(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_do_spell_check")]
    pub fn choice_do_spell_check(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_do_spell_check(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_get_choice_type")]
    pub fn choice_get_choice_type(&self) -> FormChoiceType {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_get_choice_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_get_item")]
    pub fn choice_get_item(&self, index: i32) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_form_field_choice_get_item(
                self.to_glib_none().0,
                index,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_get_n_items")]
    pub fn choice_get_n_items(&self) -> i32 {
        unsafe { ffi::poppler_form_field_choice_get_n_items(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_form_field_choice_get_text")]
    pub fn choice_get_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_form_field_choice_get_text(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_is_editable")]
    pub fn choice_is_editable(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_is_editable(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_is_item_selected")]
    pub fn choice_is_item_selected(&self, index: i32) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_choice_is_item_selected(
                self.to_glib_none().0,
                index,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_choice_select_item")]
    pub fn choice_select_item(&self, index: i32) {
        unsafe {
            ffi::poppler_form_field_choice_select_item(self.to_glib_none().0, index);
        }
    }

    #[doc(alias = "poppler_form_field_choice_set_text")]
    pub fn choice_set_text(&self, text: &str) {
        unsafe {
            ffi::poppler_form_field_choice_set_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_form_field_choice_toggle_item")]
    pub fn choice_toggle_item(&self, index: i32) {
        unsafe {
            ffi::poppler_form_field_choice_toggle_item(self.to_glib_none().0, index);
        }
    }

    #[doc(alias = "poppler_form_field_choice_unselect_all")]
    pub fn choice_unselect_all(&self) {
        unsafe {
            ffi::poppler_form_field_choice_unselect_all(self.to_glib_none().0);
        }
    }

    //#[doc(alias = "poppler_form_field_get_action")]
    //#[doc(alias = "get_action")]
    //pub fn action(&self) -> /*Ignored*/Option<Action> {
    //    unsafe { TODO: call ffi:poppler_form_field_get_action() }
    //}

    //#[cfg(feature = "v0_72")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v0_72")))]
    //#[doc(alias = "poppler_form_field_get_additional_action")]
    //#[doc(alias = "get_additional_action")]
    //pub fn additional_action(&self, type_: AdditionalActionType) -> /*Ignored*/Option<Action> {
    //    unsafe { TODO: call ffi:poppler_form_field_get_additional_action() }
    //}

    #[cfg(feature = "v0_88")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_88")))]
    #[doc(alias = "poppler_form_field_get_alternate_ui_name")]
    #[doc(alias = "get_alternate_ui_name")]
    pub fn alternate_ui_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_form_field_get_alternate_ui_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_get_field_type")]
    #[doc(alias = "get_field_type")]
    pub fn field_type(&self) -> FormFieldType {
        unsafe {
            from_glib(ffi::poppler_form_field_get_field_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_get_font_size")]
    #[doc(alias = "get_font_size")]
    pub fn font_size(&self) -> f64 {
        unsafe { ffi::poppler_form_field_get_font_size(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_form_field_get_id")]
    #[doc(alias = "get_id")]
    pub fn id(&self) -> i32 {
        unsafe { ffi::poppler_form_field_get_id(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_form_field_get_mapping_name")]
    #[doc(alias = "get_mapping_name")]
    pub fn mapping_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_form_field_get_mapping_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_form_field_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_form_field_get_partial_name")]
    #[doc(alias = "get_partial_name")]
    pub fn partial_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_form_field_get_partial_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_is_read_only")]
    pub fn is_read_only(&self) -> bool {
        unsafe { from_glib(ffi::poppler_form_field_is_read_only(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_form_field_signature_validate_async")]
    pub fn signature_validate_async<P: FnOnce(Result<SignatureInfo, glib::Error>) + 'static>(
        &self,
        flags: SignatureValidationFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn signature_validate_async_trampoline<
            P: FnOnce(Result<SignatureInfo, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_form_field_signature_validate_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = signature_validate_async_trampoline::<P>;
        unsafe {
            ffi::poppler_form_field_signature_validate_async(
                self.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    pub fn signature_validate_future(
        &self,
        flags: SignatureValidationFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<SignatureInfo, glib::Error>> + 'static>>
    {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.signature_validate_async(flags, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_form_field_signature_validate_sync")]
    pub fn signature_validate_sync(
        &self,
        flags: SignatureValidationFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<SignatureInfo, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_form_field_signature_validate_sync(
                self.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_form_field_text_do_scroll")]
    pub fn text_do_scroll(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_text_do_scroll(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_text_do_spell_check")]
    pub fn text_do_spell_check(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_text_do_spell_check(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_text_get_max_len")]
    pub fn text_get_max_len(&self) -> i32 {
        unsafe { ffi::poppler_form_field_text_get_max_len(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_form_field_text_get_text")]
    pub fn text_get_text(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_form_field_text_get_text(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_form_field_text_get_text_type")]
    pub fn text_get_text_type(&self) -> FormTextType {
        unsafe {
            from_glib(ffi::poppler_form_field_text_get_text_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_text_is_password")]
    pub fn text_is_password(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_text_is_password(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_text_is_rich_text")]
    pub fn text_is_rich_text(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_form_field_text_is_rich_text(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_form_field_text_set_text")]
    pub fn text_set_text(&self, text: &str) {
        unsafe {
            ffi::poppler_form_field_text_set_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }
}
