#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use Database::Filter;

binmode( STDOUT, "utf8" );

my $filter = Database::Filter->new(
    { filter => 'camelcase.value = 5 AND snake_case.value = 10' } );
$filter->canonicalize_table_names( 'CamelCase' );
my( $sql ) = $filter->filter->to_SQL;
print "WHERE $sql\n";
