% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{infer_unitizer_location}
\alias{infer_unitizer_location}
\alias{infer_unitizer_location.default}
\alias{infer_unitizer_location.character}
\title{Infers Possible Unitizer Path From Context}
\usage{
infer_unitizer_location(store.id, ...)

\method{infer_unitizer_location}{default}(store.id, ...)

\method{infer_unitizer_location}{character}(
  store.id,
  type = "f",
  interactive.mode = interactive(),
  ...
)
}
\arguments{
\item{store.id}{character(1L) file or directory name, the file name portion
(i.e after the last slash) may be partially specified}

\item{...}{arguments to pass on to other methods}

\item{type}{character(1L) in \code{c("f", "u", "d")}, \code{"f"} for test
file, \code{"d"} for a directory, \code{"u"} for a \code{unitizer}
directory}

\item{interactive.mode}{logical(1L) whether to allow user input to resolve
ambiguities}
}
\value{
character(1L) an inferred path, or \code{store.id} with a warning if
  path cannot be inferred
}
\description{
Used by most \code{unitizer} functions that operate on \code{unitizer}s to
make it easy to specify the most likely intended \code{unitizer} in a
package or a directory.
}
\details{
This is implemented as an S3 generic to allow third parties to define
inference methods for other types of \code{store.id}, but the documentation
here is for the \code{"character"} method which is what \code{unitizer} uses
by default.

If \code{store.id} is a directory that appears to be an R package (contains
DESCRIPTION, an R folder, a tests folder), will look for candidate files in
\code{file.path(store.id, "tests", "unitizer")}, starting with files with the
same name as the package (ending in ".R" or ".unitizer" if \code{type} is
\code{"f"} or \code{"u"} respectively), or if there is only one file, that
file, or if there are multiple candidate files and in interactive mode
prompting user for a selection.  If \code{type} is \code{"d"}, then will
just provide the \code{"tests/unitizer"} directory.

If \code{name} is not a directory, will try to find a file by that name, and
if that fails, will try to partially match a file by that name.  Partial
matching requires the front portion of the name to be fully specified and
no extension be provided (e.g. for \code{"mytests.R"}, \code{"myt"} is valid,
but \code{"tests"} and \code{"myt.R"} are both invalid).  Partially specified
files may be specified in subdirectories (e.g. \code{"tests/myt"}).

Inference assumes your files end in \code{".R"} for code files and
\code{".unitizer"} for \code{unitizer} data directories.

If \code{store.id} is NULL, the default \code{infer_unitizer_location} method
will attempt to find the top level package directory and then call the
character method with that directory as \code{store.id}.  If the parent
package directory cannot be found, then the character method is called with
the current directory as the argument.
}
\seealso{
\code{\link{get_unitizer}} for discussion of alternate
  \code{store.id} objects
}
