% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invlogit.R
\name{step_invlogit}
\alias{step_invlogit}
\alias{tidy.step_invlogit}
\title{Inverse Logit Transformation}
\usage{
step_invlogit(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("invlogit")
)

\method{tidy}{step_invlogit}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_invlogit} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which
is the columns that will be affected.
}
\description{
\code{step_invlogit} creates a \emph{specification} of a recipe
step that will transform the data from real values to be between
zero and one.
}
\details{
The inverse logit transformation takes values on the
real line and translates them to be between zero and one using
the function \code{f(x) = 1/(1+exp(-x))}.
}
\examples{
library(modeldata)
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

ilogit_trans <- rec  \%>\%
  step_center(carbon, hydrogen) \%>\%
  step_scale(carbon, hydrogen) \%>\%
  step_invlogit(carbon, hydrogen)

ilogit_obj <- prep(ilogit_trans, training = biomass_tr)

transformed_te <- bake(ilogit_obj, biomass_te)
plot(biomass_te$carbon, transformed_te$carbon)
}
\seealso{
\code{\link[=step_logit]{step_logit()}} \code{\link[=step_log]{step_log()}}
\code{\link[=step_sqrt]{step_sqrt()}}  \code{\link[=step_hyperbolic]{step_hyperbolic()}}
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{preprocessing}
\concept{transformation_methods}
\keyword{datagen}
