% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmodel2list.R
\name{hmodel2list}
\alias{hmodel2list}
\title{Convert a hmodel object to HMM constructor function calls}
\usage{
hmodel2list(hmodel, hmmdist = TRUE)
}
\arguments{
\item{hmodel}{A list of class \code{hmodel}, as returned in the \code{hmodel} component of the
fitted model object from \code{\link{msm}}.}

\item{hmmdist}{\code{TRUE} or \code{FALSE} (see "Value" section).}
}
\value{
If \code{hmmdist=TRUE}, returns a list of objects of class \code{hmmdist}. 
 These are the kind of objects
returned by HMM constructor functions such
as \code{\link{hmmNorm}}, \code{\link{hmmPois}} etc.  Therefore the list can be
passed as the \code{hmodel} argument to \code{\link{msm}}.

If \code{hmmdist=FALSE}, returns a list comprised of the corresponding input
arguments for the constructor functions, i.e. parameter values of HMM emission
distributions.   The list has one element per state.  Each of these elements 
has one element per parameter (for univariate HMMs), or one element per outcome
distribution, which in turn has one element per parameter (for multivariate HMMs).
}
\description{
Convert a hmodel object to HMM constructor function calls
}
\author{
Will Hulme \code{https://github.com/wjchulme} and Chris Jackson.
}
