% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{split_join_distance}
\alias{split_join_distance}
\title{Split-join distance of two community structures}
\usage{
split_join_distance(comm1, comm2)
}
\arguments{
\item{comm1}{The first community structure.}

\item{comm2}{The second community structure.}
}
\value{
Two integer numbers, see details below.
}
\description{
The split-join distance between partitions A and B is the sum of the
projection distance of A from B and the projection distance of B from
A. The projection distance is an asymmetric measure and it is defined as
follows:
}
\details{
First, each set in partition A is evaluated against all sets in
partition B. For each set in partition A, the best matching set in
partition B is found and the overlap size is calculated. (Matching is
quantified by the size of the overlap between the two sets). Then, the
maximal overlap sizes for each set in A are summed together and
subtracted from the number of elements in A.

The split-join distance will be returned as two numbers, the first is
the projection distance of the first partition from the
second, while the second number is the projection distance of the second
partition from the first. This makes it easier to detect whether a
partition is a subpartition of the other, since in this case, the
corresponding distance will be zero.
}
\references{
van Dongen S: Performance criteria for graph clustering and Markov
cluster experiments. Technical Report INS-R0012, National Research
Institute for Mathematics and Computer Science in the Netherlands,
Amsterdam, May 2000.
}
