% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau.R
\name{scale_colour_gradient_tableau}
\alias{scale_colour_gradient_tableau}
\alias{scale_fill_gradient_tableau}
\alias{scale_color_gradient_tableau}
\alias{scale_color_continuous_tableau}
\alias{scale_fill_continuous_tableau}
\title{Tableau sequential colour scales (continuous)}
\usage{
scale_colour_gradient_tableau(
  palette = "Blue",
  ...,
  na.value = "grey50",
  guide = "colourbar"
)

scale_fill_gradient_tableau(
  palette = "Blue",
  ...,
  na.value = "grey50",
  guide = "colourbar"
)

scale_color_gradient_tableau(
  palette = "Blue",
  ...,
  na.value = "grey50",
  guide = "colourbar"
)

scale_color_continuous_tableau(
  palette = "Blue",
  ...,
  na.value = "grey50",
  guide = "colourbar"
)

scale_fill_continuous_tableau(
  palette = "Blue",
  ...,
  na.value = "grey50",
  guide = "colourbar"
)
}
\arguments{
\item{palette}{Palette name.
\describe{
\item{\code{"ordered-sequential"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-sequential"]]))}}
\item{\code{"ordered-diverging"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-diverging"]]))}}
}}

\item{...}{Arguments passed to \code{tableau_gradient_pal}.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{'colourbar'} for continuous
colour bar, or \code{'legend'} for discrete colour legend.}
}
\description{
Continuous color scales using the sequential color palettes in Tableau.
See \funclink{scale_colour_tableau} for Tableau discrete color scales,
and \funclink{scale_colour_gradient2_tableau} for diverging color
scales.
}
\examples{
library("ggplot2")

df <- data.frame(
  x = runif(100),
  y = runif(100),
  z1 = rnorm(100),
  z2 = abs(rnorm(100))
)

p <- ggplot(df, aes(x, y)) +
     geom_point(aes(colour = z2)) +
     theme_igray()

palettes <-
  ggthemes_data[["tableau"]][["color-palettes"]][["ordered-sequential"]]
for (palette in head(names(palettes))) {
  print(p + scale_colour_gradient_tableau(palette) +
          ggtitle(palette))
}
}
\seealso{
Other colour tableau: 
\code{\link{scale_colour_gradient2_tableau}()},
\code{\link{scale_colour_tableau}()},
\code{\link{tableau_color_pal}()},
\code{\link{tableau_gradient_pal}()}
}
\concept{colour tableau}
