% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_facet.r
\name{tag_facet}
\alias{tag_facet}
\title{tag_facet}
\usage{
tag_facet(p, open = "(", close = ")", tag_pool = letters, x = -Inf,
  y = Inf, hjust = -0.5, vjust = 1.5, fontface = 2, family = "",
  ...)
}
\arguments{
\item{p}{ggplot}

\item{open}{opening character, default: (}

\item{close}{closing character, default: )}

\item{tag_pool}{character vector to pick tags from}

\item{x}{x position within panel, default: -Inf}

\item{y}{y position within panel, default: Inf}

\item{hjust}{hjust}

\item{vjust}{vjust}

\item{fontface}{fontface}

\item{family}{font family}

\item{...}{further arguments passed to geom_text layer}
}
\value{
plot with facet strips removed and replaced by in-panel tags
}
\description{
Adds a dummy text layer to a ggplot to label facets and sets facet strips to blank. 
This is the typical formatting for some journals that consider facets as subfigures 
and want to minimise margins around figures.
}
\examples{
library(ggplot2)
mydf = data.frame(
  x = 1:90,
  y = rnorm(90),
  red = rep(letters[1:3], 30),
  blue = c(rep(1, 30), rep(2, 30), rep(3, 30)))

p <- ggplot(mydf) +
  geom_point(aes(x = x, y = y)) +
  facet_wrap(
    ~ red + blue)
tag_facet(p)
}
