% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A1-R1C1-regex-utils.R
\name{guess_fo}
\alias{guess_fo}
\title{Guess cell reference string format}
\usage{
guess_fo(x, fo = c("R1C1", "A1"))
}
\arguments{
\item{x}{character vector of cell reference strings}

\item{fo}{default to assume if format is ambiguous}
}
\value{
character vector consisting of \code{R1C1}, \code{A1}, or \code{NA}
}
\description{
Guess if cell references are in R1C1 or A1 format.
}
\examples{
A1 <- c("A1", "$A1", "A$1", "$A$1", "a1")
guess_fo(A1)
R1C1 <- c("R1C1", "R1C[-1]", "R[-1]C1", "R[-1]C[9]")
guess_fo(R1C1)

guess_fo("RC2")
guess_fo("12")
guess_fo(12)
}

