% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_tax_name.R
\name{bold_tax_name}
\alias{bold_tax_name}
\title{Search BOLD for taxonomy data by taxonomic name}
\usage{
bold_tax_name(
  name,
  fuzzy = FALSE,
  response = FALSE,
  tax_division = NULL,
  tax_rank = NULL,
  ...
)
}
\arguments{
\item{name}{(character) One or more scientific names. required.}

\item{fuzzy}{(logical) Whether to use fuzzy search or not (default: \code{FALSE})}

\item{response}{(logical) Default : FALSE. If TRUE, returns the object from
the Curl call. Useful for debugging and getting more detailed info on the
API call.}

\item{tax_division}{(character) Taxonomic division to filter the results.}

\item{tax_rank}{(character) Taxonomic rank to filter the results.}

\item{...}{Further args passed on to
\code{\link[crul:verb-GET]{crul::verb-GET}}, main purpose being curl
debugging}
}
\description{
Search BOLD for taxonomy data by taxonomic name
}
\details{
The \code{dataTypes} parameter is not supported in this function.
If you want to use that parameter, get an ID from this function and pass
it into \code{bold_tax_id}, and then use the \code{dataTypes} parameter.
}
\note{
The column 'specimenrecords' in the returned object represents the number of species records in BOLD's \emph{Taxonomy Browser}, not the number of records in the \emph{Public Data Portal}. To know the amount of public records available, use \code{\link{bold_stats}}.
}
\examples{
\dontrun{
bold_tax_name(name='Diplura')
bold_tax_name(name='Osmia')
bold_tax_name(name=c('Diplura','Osmia'))
bold_tax_name(name=c("Apis","Puma concolor","Pinus concolor"))
bold_tax_name(name='Diplur', fuzzy=TRUE)
bold_tax_name(name='Osm', fuzzy=TRUE)

## get http response object only
bold_tax_name(name='Diplura', response=TRUE)
bold_tax_name(name=c('Diplura','Osmia'), response=TRUE)

## Names with no data in BOLD database
bold_tax_name("Nasiaeshna pentacantha")
bold_tax_name(name = "Cordulegaster erronea")
bold_tax_name(name = "Cordulegaster erronea", response=TRUE)

## curl debugging
bold_tax_name(name='Diplura', verbose = TRUE)
}
}
\references{
Taxonomy API: http://v4.boldsystems.org/index.php/resources/api?type=taxonomy
Taxonomy Browser: https://www.boldsystems.org/index.php/TaxBrowser_Home
Public Data Portal: https://www.boldsystems.org/index.php/Public_BINSearch?searchtype=records
}
\seealso{
\code{\link{bold_tax_id}}, \code{\link{bold_get_attr}}, \code{\link{bold_get_errors}}, \code{\link{bold_get_params}}
}
