% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.pdb.R
\name{clean.pdb}
\alias{clean.pdb}
\title{Inspect And Clean Up A PDB Object}
\usage{
clean.pdb(pdb, consecutive = TRUE, force.renumber = FALSE,
  fix.chain = FALSE, fix.aa = FALSE, rm.wat = FALSE, rm.lig = FALSE,
  rm.h = FALSE, verbose = FALSE)
}
\arguments{
\item{pdb}{an object of class \code{pdb} as obtained from
function \code{\link{read.pdb}}.}

\item{consecutive}{logical, if TRUE renumbering will result in
consecutive residue numbers spanning all chains. Otherwise new residue
numbers will begin at 1 for each chain.}

\item{force.renumber}{logical, if TRUE atom and residue records are renumbered 
even if no 'insert' code is found in the \code{pdb} object.}

\item{fix.chain}{logical, if TRUE chains are relabeled based on chain breaks detected.}

\item{fix.aa}{logical, if TRUE non-standard amino acid names are converted into 
equivalent standard names.}

\item{rm.wat}{logical, if TRUE water atoms are removed.}

\item{rm.lig}{logical, if TRUE ligand atoms are removed.}

\item{rm.h}{logical, if TRUE hydrogen atoms are removed.}

\item{verbose}{logical, if TRUE details of the conversion process are printed.}
}
\value{
a 'pdb' object with an additional \code{$log} component storing 
   all the processing messages.
}
\description{
Inspect alternative coordinates, chain breaks, bad residue
numbering, non-standard/unknow amino acids, etc. Return
a 'clean' pdb object with fixed residue numbering and optionally
relabeled chain IDs, corrected amino acid names, removed water,
ligand, or hydrogen atoms. All changes are recorded in a log in the 
returned object.
}
\details{
call for its effects.
}
\examples{
\donttest{
   # PDB server connection required - testing excluded
   try({

   pdb <- read.pdb("1a7l")
   clean.pdb(pdb)

   }, silent=TRUE)
   if(inherits(.Last.value, "try-error")) {
      message("Need internet to run the example")
   }  
} 
}
\author{
Xin-Qiu Yao & Barry Grant
}
\seealso{
\code{\link{read.pdb}}
}

