% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapsing.R
\name{collapsing}
\alias{collapsing}
\title{Dynamic content based on the available resolution}
\description{
When plotting features linearly along genomic coordinates one frequently
runs into the problem of too little resolution to adequately display all
details. Most genome browsers try to reasonably reduce the amount of detail
that is shown based on the current zoom level.
}
\details{
Most track classes in this package define an internal \code{collapseTrack}
method which tries to adjust the plotted content to the available
resolution, aims at reducing over-plotting and prevents rendering issues,
e.g. when lines are too thin to be plotted. This feature can be toggled on
or off using the \code{collapse} display parameter (see
\code{settings} for details on setting these parameters).

In the simplest case (for \code{AnnotationTrack} objects) this
involves expanding all shown features to a minimum pixel width and height
(using display parameters \code{min.width} and \code{min.heigh}) and
collapsing overlapping annotation items (as defined by the parameter
\code{min.distance} into one single item to prevent over-plotting.

For objects of class \code{DataTrack}, the data values
underlying collapsed regions will be summarized based on the \code{summary}
display parameter. See the class' documentation for more details.
}
\seealso{
\code{\linkS4class{AnnotationTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{settings}}
}
