% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRangedSummarizedExperiment.R
\name{saveRangedSummarizedExperiment}
\alias{saveRangedSummarizedExperiment}
\alias{stageObject,RangedSummarizedExperiment-method}
\alias{saveObject,RangedSummarizedExperiment-method}
\title{Save a RangedSummarizedExperiment to disk}
\usage{
\S4method{saveObject}{RangedSummarizedExperiment}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{RangedSummarizedExperiment} object or one of its subclasses.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to \code{"\link{saveObject,SummarizedExperiment-method}"} and internal \code{\link{altSaveObject}} calls.}
}
\value{
\code{x} is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{RangedSummarizedExperiment} to its on-disk representation.
}
\examples{
mat <- matrix(rpois(10000, 10), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

gr <- GRanges("chrA", IRanges(1:1000, width=10))
se <- SummarizedExperiment(list(counts=mat), rowRanges=gr)
se$stuff <- LETTERS[1:10]
rowData(se)$blah <- runif(1000)
metadata(se)$whee <- "YAY"

tmp <- tempfile()
saveObject(se, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readRangedSummarizedExperiment}}, to read the RangedSummarizedExperiment back into the R session.
}
\author{
Aaron Lun
}
