/*
 * Copyright 2008, The Android Open Source Project
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TouchList_h
#define TouchList_h

#if ENABLE(IOS_TOUCH_EVENTS)
#include <WebKitAdditions/TouchListIOS.h>
#elif ENABLE(TOUCH_EVENTS)

#include "Touch.h"
#include <wtf/RefCounted.h>
#include <wtf/Vector.h>

namespace WebCore {

class TouchList : public RefCounted<TouchList> {
public:
    static Ref<TouchList> create()
    {
        return adoptRef(*new TouchList);
    }

    unsigned length() const { return m_values.size(); }

    Touch* item(unsigned);
    const Touch* item(unsigned) const;

    void append(const PassRefPtr<Touch> touch) { m_values.append(touch); }

private:
    TouchList() {}

    Vector<RefPtr<Touch> > m_values;
};

} // namespace WebCore

#endif // ENABLE(TOUCH_EVENTS)

#endif /* TouchList_h */
