// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package tag

const (
	// Label holds the string label denoting the tag type in the database.
	Label = "tag"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldValue holds the string denoting the value field in the database.
	FieldValue = "value"
	// EdgeTweets holds the string denoting the tweets edge name in mutations.
	EdgeTweets = "tweets"
	// EdgeTweetTags holds the string denoting the tweet_tags edge name in mutations.
	EdgeTweetTags = "tweet_tags"
	// Table holds the table name of the tag in the database.
	Table = "tags"
	// TweetsTable is the table that holds the tweets relation/edge. The primary key declared below.
	TweetsTable = "tweet_tags"
	// TweetsInverseTable is the table name for the Tweet entity.
	// It exists in this package in order to avoid circular dependency with the "tweet" package.
	TweetsInverseTable = "tweets"
	// TweetTagsTable is the table that holds the tweet_tags relation/edge.
	TweetTagsTable = "tweet_tags"
	// TweetTagsInverseTable is the table name for the TweetTag entity.
	// It exists in this package in order to avoid circular dependency with the "tweettag" package.
	TweetTagsInverseTable = "tweet_tags"
	// TweetTagsColumn is the table column denoting the tweet_tags relation/edge.
	TweetTagsColumn = "tag_id"
)

// Columns holds all SQL columns for tag fields.
var Columns = []string{
	FieldID,
	FieldValue,
}

var (
	// TweetsPrimaryKey and TweetsColumn2 are the table columns denoting the
	// primary key for the tweets relation (M2M).
	TweetsPrimaryKey = []string{"tag_id", "tweet_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}
