/*
 * Entagged Audio Tag library
 * Copyright (c) 2003-2005 Raphal Slinckx <raphael@slinckx.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *  
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package entagged.audioformats.exceptions;

/**
 * This exception is thrown if the writing process of an audio file failed.
 * 
 * @author Raphal Slinckx
 */
public class CannotWriteException extends Exception {
	/**
	 * (overridden)
	 * 
	 * @see Exception#Exception()
	 */
	public CannotWriteException() {
		super();
	}

	/**
	 * (overridden)
	 * 
	 * @see Exception#Exception(java.lang.String)
	 */
	public CannotWriteException(String message) {
		super(message);
	}

	/**
	 * (overridden)
	 * 
	 * @see Exception#Exception(java.lang.String, java.lang.Throwable)
	 */
	public CannotWriteException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * (overridden)
	 * 
	 * @see Exception#Exception(java.lang.Throwable)
	 */
	public CannotWriteException(Throwable cause) {
		super(cause);

	}

}
