/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffConstraints {
    public static void createConstraints(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, boolean bl, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(pgTable.getName());
            for (PgConstraint pgConstraint : PgDiffConstraints.getNewConstraints(pgTable2, pgTable, bl)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgConstraint.getCreationSQL());
            }
        }
    }

    public static void dropConstraints(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, boolean bl, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(pgTable.getName());
            for (PgConstraint pgConstraint : PgDiffConstraints.getDropConstraints(pgTable2, pgTable, bl)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgConstraint.getDropSQL());
            }
        }
    }

    private static List<PgConstraint> getDropConstraints(PgTable pgTable, PgTable pgTable2, boolean bl) {
        ArrayList<PgConstraint> arrayList = new ArrayList<PgConstraint>();
        if (pgTable2 != null && pgTable != null) {
            for (PgConstraint pgConstraint : pgTable.getConstraints()) {
                if (pgConstraint.isPrimaryKeyConstraint() != bl || pgTable2.containsConstraint(pgConstraint.getName()) && pgTable2.getConstraint(pgConstraint.getName()).equals(pgConstraint)) continue;
                arrayList.add(pgConstraint);
            }
        }
        return arrayList;
    }

    private static List<PgConstraint> getNewConstraints(PgTable pgTable, PgTable pgTable2, boolean bl) {
        ArrayList<PgConstraint> arrayList;
        block4: {
            arrayList = new ArrayList<PgConstraint>();
            if (pgTable2 == null) break block4;
            if (pgTable == null) {
                for (PgConstraint pgConstraint : pgTable2.getConstraints()) {
                    if (pgConstraint.isPrimaryKeyConstraint() != bl) continue;
                    arrayList.add(pgConstraint);
                }
            } else {
                for (PgConstraint pgConstraint : pgTable2.getConstraints()) {
                    if (pgConstraint.isPrimaryKeyConstraint() != bl || pgTable.containsConstraint(pgConstraint.getName()) && pgTable.getConstraint(pgConstraint.getName()).equals(pgConstraint)) continue;
                    arrayList.add(pgConstraint);
                }
            }
        }
        return arrayList;
    }

    public static void alterComments(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgTable pgTable : pgSchema.getTables()) {
            PgTable pgTable2 = pgSchema2.getTable(pgTable.getName());
            if (pgTable2 == null) continue;
            for (PgConstraint pgConstraint : pgTable.getConstraints()) {
                PgConstraint pgConstraint2 = pgTable2.getConstraint(pgConstraint.getName());
                if (pgConstraint2 == null) continue;
                if (pgConstraint.getComment() == null && pgConstraint2.getComment() != null || pgConstraint.getComment() != null && pgConstraint2.getComment() != null && !pgConstraint.getComment().equals(pgConstraint2.getComment())) {
                    searchPathHelper.outputSearchPath(printWriter);
                    printWriter.println();
                    printWriter.print("COMMENT ON ");
                    if (pgConstraint2.isPrimaryKeyConstraint()) {
                        printWriter.print("INDEX ");
                        printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getName()));
                    } else {
                        printWriter.print("CONSTRAINT ");
                        printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getName()));
                        printWriter.print(" ON ");
                        printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getTableName()));
                    }
                    printWriter.print(" IS ");
                    printWriter.print(pgConstraint2.getComment());
                    printWriter.println(';');
                    continue;
                }
                if (pgConstraint.getComment() == null || pgConstraint2.getComment() != null) continue;
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON ");
                if (pgConstraint2.isPrimaryKeyConstraint()) {
                    printWriter.print("INDEX ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getName()));
                } else {
                    printWriter.print("CONSTRAINT ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getName()));
                    printWriter.print(" ON ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgConstraint2.getTableName()));
                }
                printWriter.println(" IS NULL;");
            }
        }
    }

    private PgDiffConstraints() {
    }
}

