/**
 * PostScript helper routines. Each function simply writes on standard output.
 * 
 * @file
 * @author Umberto Salsi <salsi@icosaedro.it>
 * @version $Date: 2017/10/08 23:58:48 $
 */

#ifndef PS_H
#define PS_H

#ifdef ps_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef struct ps_Type ps_Type;

/**
 * Allocates a new ps_Type.
 * @return New ps_Type. Must be released with memory_dispose().
 */
EXTERN ps_Type * ps_new(void);

EXTERN void ps_setClipRect(ps_Type *this, double x, double y, double w, double h);

EXTERN void ps_setFontHeight(ps_Type *this, int h);

EXTERN void ps_setLineWidth(ps_Type *this, double w);

EXTERN void ps_moveTo(ps_Type *this, double x, double y);

EXTERN void ps_lineTo(ps_Type *this, double x, double y);

EXTERN void ps_relativeLineTo(ps_Type *this, double x, double y);

EXTERN void ps_stroke(ps_Type *this);

EXTERN void ps_drawLine(ps_Type *this, double x1, double y1, double x2, double y2);

EXTERN void ps_setGray(ps_Type *this, double brightness);

EXTERN void ps_drawRect(ps_Type *this, double x, double y, double w, double h);

EXTERN void ps_fillRect(ps_Type *this, double x, double y, double w, double h);

/**
 * Draws a rectangular white box with black border.
 */
EXTERN void ps_drawFramedRect(ps_Type *this, double x, double y, double w, double h);

EXTERN void ps_drawCircumference(ps_Type *this, double x, double y, double r);

EXTERN void ps_drawCircle(ps_Type *this, double x, double y, double r);

/**
 * Print ASCII printable only string properly PostScript escaped.
 * @param s
 */
EXTERN void ps_printEscapedString(ps_Type *this, char *s);

/**
 * Draws a string at the current location. The following special entities are
 * recognized and translated to PostScript: "&degree;", "&multiply;".
 * @param s ASCII printable chars only supported.
 */
EXTERN void ps_drawString(ps_Type *this, char *s);

EXTERN void ps_close(ps_Type *this);

#undef EXTERN
#endif
