#!/bin/sh
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslahsplay.it>
set -o errexit

###
# Puzzle Agent series:
# - Puzzle Agent
# - Puzzle Agent 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240929.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID_EPISODE1='puzzle-agent-1'
GAME_NAME_EPISODE1='Puzzle Agent'

GAME_ID_EPISODE2='puzzle-agent-2'
GAME_NAME_EPISODE2='Puzzle Agent 2'

ARCHIVE_BASE_EPISODE1_1_NAME='setup_puzzle_agent_1.0_(21444).exe'
ARCHIVE_BASE_EPISODE1_1_MD5='b986c9a9ed5bce6f8329cc76965ee295'
ARCHIVE_BASE_EPISODE1_1_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_1_SIZE='260000'
ARCHIVE_BASE_EPISODE1_1_VERSION='1.0-gog21444'
ARCHIVE_BASE_EPISODE1_1_URL='https://www.gog.com/game/puzzle_agent'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_puzzle_agent_2.0.0.3.exe'
ARCHIVE_BASE_EPISODE1_0_MD5='68155b4aff9aa9e28c107f5b2ff994b5'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='260000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog2.0.0.3'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_puzzle_agent_2_1.0_(21444).exe'
ARCHIVE_BASE_EPISODE2_0_MD5='f3065abf496f53be933c2ab8a2b70dd7'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='410000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog21444'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/puzzle_agent_2'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_EPISODE1_0='app'
CONTENT_GAME_BIN_FILES='
fmodex.dll
grickle101.exe
grickle102.exe'
## TODO: Check if the Steam library is required.
CONTENT_GAME0_BIN_FILES='
steam_api.dll'
CONTENT_GAME_DATA_FILES='
pack'

WINE_PERSISTENT_DIRECTORIES_EPISODE1='
users/${USER}/Documents/Telltale Games/puzzle-agent'
WINE_PERSISTENT_DIRECTORIES_EPISODE2='
users/${USER}/Documents/Telltale Games/puzzle-agent-2'
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE_EPISODE1='grickle101.exe'
APP_MAIN_EXE_EPISODE2='grickle102.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure smooth upgrade from packages generated with pre-20210928.2 game scripts
PKG_BIN_PROVIDES_EPISODE1="${PKG_BIN_PROVIDES_EPISODE1:-}
puzzle-agent"

PKG_DATA_ID_EPISODE1="${GAME_ID_EPISODE1}-data"
PKG_DATA_ID_EPISODE2="${GAME_ID_EPISODE2}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure smooth upgrade from packages generated with pre-20210928.2 game scripts
PKG_DATA_PROVIDES_EPISODE1="${PKG_DATA_PROVIDES_EPISODE1:-}
puzzle-agent-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
