/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magmablas_z.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmablasf_ztranspose_inplace FORTRAN_NAME( magmablasf_ztranspose_inplace, MAGMABLASF_ZTRANSPOSE_INPLACE )
void magmablasf_ztranspose_inplace(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_ztranspose_inplace(
        *n,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmablasf_ztranspose_conj_inplace FORTRAN_NAME( magmablasf_ztranspose_conj_inplace, MAGMABLASF_ZTRANSPOSE_CONJ_INPLACE )
void magmablasf_ztranspose_conj_inplace(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_ztranspose_conj_inplace(
        *n,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmablasf_ztranspose FORTRAN_NAME( magmablasf_ztranspose, MAGMABLASF_ZTRANSPOSE )
void magmablasf_ztranspose(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dAT, magma_int_t *lddat, magma_queue_t *queue )
{
    magmablas_ztranspose(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dAT), *lddat, *queue );
}

#define magmablasf_ztranspose_conj FORTRAN_NAME( magmablasf_ztranspose_conj, MAGMABLASF_ZTRANSPOSE_CONJ )
void magmablasf_ztranspose_conj(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dAT, magma_int_t *lddat, magma_queue_t *queue )
{
    magmablas_ztranspose_conj(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dAT), *lddat, *queue );
}

#define magmablasf_zgetmatrix_transpose FORTRAN_NAME( magmablasf_zgetmatrix_transpose, MAGMABLASF_ZGETMATRIX_TRANSPOSE )
void magmablasf_zgetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    devptr_t *dAT, magma_int_t *ldda,
    magmaDoubleComplex *hA, magma_int_t *lda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_zgetmatrix_transpose(
        *m, *n, *nb,
        magma_zdevptr(dAT), *ldda,
        hA, *lda,
        magma_zdevptr(dwork), *lddw,
        queues );
}

#define magmablasf_zsetmatrix_transpose FORTRAN_NAME( magmablasf_zsetmatrix_transpose, MAGMABLASF_ZSETMATRIX_TRANSPOSE )
void magmablasf_zsetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    magmaDoubleComplex *hA, magma_int_t *lda,
    devptr_t *dAT, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_zsetmatrix_transpose(
        *m, *n, *nb,
        hA, *lda,
        magma_zdevptr(dAT), *ldda,
        magma_zdevptr(dwork), *lddw,
        queues );
}

#define magmablasf_zprbt FORTRAN_NAME( magmablasf_zprbt, MAGMABLASF_ZPRBT )
void magmablasf_zprbt(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *du,
    devptr_t *dv, magma_queue_t *queue )
{
    magmablas_zprbt(
        *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(du),
        magma_zdevptr(dv), *queue );
}

#define magmablasf_zprbt_mv FORTRAN_NAME( magmablasf_zprbt_mv, MAGMABLASF_ZPRBT_MV )
void magmablasf_zprbt_mv(
    magma_int_t *n,
    devptr_t *dv,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_zprbt_mv(
        *n,
        magma_zdevptr(dv),
        magma_zdevptr(db), *queue );
}

#define magmablasf_zprbt_mtv FORTRAN_NAME( magmablasf_zprbt_mtv, MAGMABLASF_ZPRBT_MTV )
void magmablasf_zprbt_mtv(
    magma_int_t *n,
    devptr_t *du,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_zprbt_mtv(
        *n,
        magma_zdevptr(du),
        magma_zdevptr(db), *queue );
}

#define magmablasf_zgeadd FORTRAN_NAME( magmablasf_zgeadd, MAGMABLASF_ZGEADD )
void magmablasf_zgeadd(
    magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_zgeadd(
        *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_zgeadd2 FORTRAN_NAME( magmablasf_zgeadd2, MAGMABLASF_ZGEADD2 )
void magmablasf_zgeadd2(
    magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda, magmaDoubleComplex *beta,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_zgeadd2(
        *m, *n, *alpha,
        magma_zdevptr(dA), *ldda, *beta,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_zlacpy FORTRAN_NAME( magmablasf_zlacpy, MAGMABLASF_ZLACPY )
void magmablasf_zlacpy(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_zlacpy(
        magma_uplo_const(*uplo), *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_zlacpy_conj FORTRAN_NAME( magmablasf_zlacpy_conj, MAGMABLASF_ZLACPY_CONJ )
void magmablasf_zlacpy_conj(
    magma_int_t *n,
    devptr_t *dA1, magma_int_t *lda1,
    devptr_t *dA2, magma_int_t *lda2, magma_queue_t *queue )
{
    magmablas_zlacpy_conj(
        *n,
        magma_zdevptr(dA1), *lda1,
        magma_zdevptr(dA2), *lda2, *queue );
}

#define magmablasf_zlacpy_sym_in FORTRAN_NAME( magmablasf_zlacpy_sym_in, MAGMABLASF_ZLACPY_SYM_IN )
void magmablasf_zlacpy_sym_in(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_zlacpy_sym_in(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_zlacpy_sym_out FORTRAN_NAME( magmablasf_zlacpy_sym_out, MAGMABLASF_ZLACPY_SYM_OUT )
void magmablasf_zlacpy_sym_out(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_zlacpy_sym_out(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_zlange FORTRAN_NAME( magmablasf_zlange, MAGMABLASF_ZLANGE )
double magmablasf_zlange(
    const char* norm, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_zlange(
        magma_norm_const(*norm), *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_ddevptr(dwork), *lwork, *queue );
}

#define magmablasf_zlanhe FORTRAN_NAME( magmablasf_zlanhe, MAGMABLASF_ZLANHE )
double magmablasf_zlanhe(
    const char* norm, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_zlanhe(
        magma_norm_const(*norm), magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        magma_ddevptr(dwork), *lwork, *queue );
}

#define magmablasf_zlascl FORTRAN_NAME( magmablasf_zlascl, MAGMABLASF_ZLASCL )
void magmablasf_zlascl(
    const char* type, magma_int_t *kl, magma_int_t *ku, double *cfrom, double *cto, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_zlascl(
        magma_uplo_const(*type), *kl, *ku, *cfrom, *cto, *m, *n,
        magma_zdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_zlascl_2x2 FORTRAN_NAME( magmablasf_zlascl_2x2, MAGMABLASF_ZLASCL_2X2 )
void magmablasf_zlascl_2x2(
    const char* type, magma_int_t *m,
    devptr_t *dW, magma_int_t *lddw,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_zlascl_2x2(
        magma_uplo_const(*type), *m,
        magma_zdevptr(dW), *lddw,
        magma_zdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_zlascl2 FORTRAN_NAME( magmablasf_zlascl2, MAGMABLASF_ZLASCL2 )
void magmablasf_zlascl2(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_zlascl2(
        magma_uplo_const(*type), *m, *n,
        magma_ddevptr(dD),
        magma_zdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_zlascl_diag FORTRAN_NAME( magmablasf_zlascl_diag, MAGMABLASF_ZLASCL_DIAG )
void magmablasf_zlascl_diag(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD, magma_int_t *lddd,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_zlascl_diag(
        magma_uplo_const(*type), *m, *n,
        magma_zdevptr(dD), *lddd,
        magma_zdevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_zlaset FORTRAN_NAME( magmablasf_zlaset, MAGMABLASF_ZLASET )
void magmablasf_zlaset(
    const char* uplo, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *offdiag, magmaDoubleComplex *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_zlaset(
        magma_uplo_const(*uplo), *m, *n, *offdiag, *diag,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmablasf_zlaset_band FORTRAN_NAME( magmablasf_zlaset_band, MAGMABLASF_ZLASET_BAND )
void magmablasf_zlaset_band(
    const char* uplo, magma_int_t *m, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *offdiag, magmaDoubleComplex *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_zlaset_band(
        magma_uplo_const(*uplo), *m, *n, *k, *offdiag, *diag,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmablasf_zlaswp FORTRAN_NAME( magmablasf_zlaswp, MAGMABLASF_ZLASWP )
void magmablasf_zlaswp(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_zlaswp(
        *n,
        magma_zdevptr(dAT), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_zlaswp2 FORTRAN_NAME( magmablasf_zlaswp2, MAGMABLASF_ZLASWP2 )
void magmablasf_zlaswp2(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    devptr_t *d_ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_zlaswp2(
        *n,
        magma_zdevptr(dAT), *ldda, *k1, *k2,
        magma_idevptr(d_ipiv), *inci, *queue );
}

#define magmablasf_zlaswp_sym FORTRAN_NAME( magmablasf_zlaswp_sym, MAGMABLASF_ZLASWP_SYM )
void magmablasf_zlaswp_sym(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_zlaswp_sym(
        *n,
        magma_zdevptr(dA), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_zlaswpx FORTRAN_NAME( magmablasf_zlaswpx, MAGMABLASF_ZLASWPX )
void magmablasf_zlaswpx(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldx, magma_int_t *ldy, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_zlaswpx(
        *n,
        magma_zdevptr(dA), *ldx, *ldy, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_zsymmetrize FORTRAN_NAME( magmablasf_zsymmetrize, MAGMABLASF_ZSYMMETRIZE )
void magmablasf_zsymmetrize(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_zsymmetrize(
        magma_uplo_const(*uplo), *m,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmablasf_zsymmetrize_tiles FORTRAN_NAME( magmablasf_zsymmetrize_tiles, MAGMABLASF_ZSYMMETRIZE_TILES )
void magmablasf_zsymmetrize_tiles(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *ntile, magma_int_t *mstride, magma_int_t *nstride, magma_queue_t *queue )
{
    magmablas_zsymmetrize_tiles(
        magma_uplo_const(*uplo), *m,
        magma_zdevptr(dA), *ldda, *ntile, *mstride, *nstride, *queue );
}

#define magmablasf_ztrtri_diag FORTRAN_NAME( magmablasf_ztrtri_diag, MAGMABLASF_ZTRTRI_DIAG )
void magmablasf_ztrtri_diag(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *d_dinvA, magma_queue_t *queue )
{
    magmablas_ztrtri_diag(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(d_dinvA), *queue );
}

#define magmaf_zlarfb_gpu FORTRAN_NAME( magmaf_zlarfb_gpu, MAGMAF_ZLARFB_GPU )
magma_int_t magmaf_zlarfb_gpu(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_zlarfb_gpu(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_zdevptr(dV), *lddv,
        magma_zdevptr(dT), *lddt,
        magma_zdevptr(dC), *lddc,
        magma_zdevptr(dwork), *ldwork, *queue );
}

#define magmaf_zlarfb_gpu_gemm FORTRAN_NAME( magmaf_zlarfb_gpu_gemm, MAGMAF_ZLARFB_GPU_GEMM )
magma_int_t magmaf_zlarfb_gpu_gemm(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork,
    devptr_t *dworkvt, magma_int_t *ldworkvt, magma_queue_t *queue )
{
    return magma_zlarfb_gpu_gemm(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_zdevptr(dV), *lddv,
        magma_zdevptr(dT), *lddt,
        magma_zdevptr(dC), *lddc,
        magma_zdevptr(dwork), *ldwork,
        magma_zdevptr(dworkvt), *ldworkvt, *queue );
}

#define magmaf_zlarfbx_gpu FORTRAN_NAME( magmaf_zlarfbx_gpu, MAGMAF_ZLARFBX_GPU )
void magmaf_zlarfbx_gpu(
    magma_int_t *m, magma_int_t *k,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *dT, magma_int_t *ldt,
    devptr_t *c,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_zlarfbx_gpu(
        *m, *k,
        magma_zdevptr(V), *ldv,
        magma_zdevptr(dT), *ldt,
        magma_zdevptr(c),
        magma_zdevptr(dwork), *queue );
}

#define magmaf_zlarfgtx_gpu FORTRAN_NAME( magmaf_zlarfgtx_gpu, MAGMAF_ZLARFGTX_GPU )
void magmaf_zlarfgtx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *T, magma_int_t *ldt,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_zlarfgtx_gpu(
        *n,
        magma_zdevptr(dx0),
        magma_zdevptr(dx),
        magma_zdevptr(dtau),
        magma_ddevptr(dxnorm),
        magma_zdevptr(dA), *iter,
        magma_zdevptr(V), *ldv,
        magma_zdevptr(T), *ldt,
        magma_zdevptr(dwork), *queue );
}

#define magmaf_zlarfgx_gpu FORTRAN_NAME( magmaf_zlarfgx_gpu, MAGMAF_ZLARFGX_GPU )
void magmaf_zlarfgx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter, magma_queue_t *queue )
{
    magma_zlarfgx_gpu(
        *n,
        magma_zdevptr(dx0),
        magma_zdevptr(dx),
        magma_zdevptr(dtau),
        magma_ddevptr(dxnorm),
        magma_zdevptr(dA), *iter, *queue );
}

#define magmaf_zlarfx_gpu FORTRAN_NAME( magmaf_zlarfx_gpu, MAGMAF_ZLARFX_GPU )
void magmaf_zlarfx_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *v,
    devptr_t *tau,
    devptr_t *C, magma_int_t *ldc,
    devptr_t *xnorm,
    devptr_t *dT, magma_int_t *iter,
    devptr_t *work, magma_queue_t *queue )
{
    magma_zlarfx_gpu(
        *m, *n,
        magma_zdevptr(v),
        magma_zdevptr(tau),
        magma_zdevptr(C), *ldc,
        magma_ddevptr(xnorm),
        magma_zdevptr(dT), *iter,
        magma_zdevptr(work), *queue );
}

#define magmablasf_zaxpycp FORTRAN_NAME( magmablasf_zaxpycp, MAGMABLASF_ZAXPYCP )
void magmablasf_zaxpycp(
    magma_int_t *m,
    devptr_t *dr,
    devptr_t *dx,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_zaxpycp(
        *m,
        magma_zdevptr(dr),
        magma_zdevptr(dx),
        magma_zdevptr(db), *queue );
}

#define magmablasf_zswap FORTRAN_NAME( magmablasf_zswap, MAGMABLASF_ZSWAP )
void magmablasf_zswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_zswap(
        *n,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmablasf_zswapblk FORTRAN_NAME( magmablasf_zswapblk, MAGMABLASF_ZSWAPBLK )
void magmablasf_zswapblk(
    const char* order, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *i1, magma_int_t *i2,
    magma_int_t *ipiv, magma_int_t *inci, magma_int_t *offset, magma_queue_t *queue )
{
    magmablas_zswapblk(
        magma_order_const(*order), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *i1, *i2,
        ipiv, *inci, *offset, *queue );
}

#define magmablasf_zswapdblk FORTRAN_NAME( magmablasf_zswapdblk, MAGMABLASF_ZSWAPDBLK )
void magmablasf_zswapdblk(
    magma_int_t *n, magma_int_t *nb,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *inca,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_zswapdblk(
        *n, *nb,
        magma_zdevptr(dA), *ldda, *inca,
        magma_zdevptr(dB), *lddb, *incb, *queue );
}

#define magmablasf_dznrm2_adjust FORTRAN_NAME( magmablasf_dznrm2_adjust, MAGMABLASF_DZNRM2_ADJUST )
void magmablasf_dznrm2_adjust(
    magma_int_t *k,
    devptr_t *dxnorm,
    devptr_t *dc, magma_queue_t *queue )
{
    magmablas_dznrm2_adjust(
        *k,
        magma_ddevptr(dxnorm),
        magma_zdevptr(dc), *queue );
}

#define magmablasf_dznrm2_check FORTRAN_NAME( magmablasf_dznrm2_check, MAGMABLASF_DZNRM2_CHECK )
void magmablasf_dznrm2_check(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_dznrm2_check(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_ddevptr(dxnorm),
        magma_ddevptr(dlsticc), *queue );
}

#define magmablasf_dznrm2_cols FORTRAN_NAME( magmablasf_dznrm2_cols, MAGMABLASF_DZNRM2_COLS )
void magmablasf_dznrm2_cols(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm, magma_queue_t *queue )
{
    magmablas_dznrm2_cols(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_ddevptr(dxnorm), *queue );
}

#define magmablasf_dznrm2_row_check_adjust FORTRAN_NAME( magmablasf_dznrm2_row_check_adjust, MAGMABLASF_DZNRM2_ROW_CHECK_ADJUST )
void magmablasf_dznrm2_row_check_adjust(
    magma_int_t *k, double *tol,
    devptr_t *dxnorm,
    devptr_t *dxnorm2,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_dznrm2_row_check_adjust(
        *k, *tol,
        magma_ddevptr(dxnorm),
        magma_ddevptr(dxnorm2),
        magma_zdevptr(dC), *lddc,
        magma_ddevptr(dlsticc), *queue );
}

#define magmablasf_ztrsv FORTRAN_NAME( magmablasf_ztrsv, MAGMABLASF_ZTRSV )
void magmablasf_ztrsv(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_ztrsv(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(db), *incb, *queue );
}

#define magmablasf_ztrsv_outofplace FORTRAN_NAME( magmablasf_ztrsv_outofplace, MAGMABLASF_ZTRSV_OUTOFPLACE )
void magmablasf_ztrsv_outofplace(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb,
    devptr_t *dx, magma_queue_t *queue, magma_int_t *flag )
{
    magmablas_ztrsv_outofplace(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(db), *incb,
        magma_zdevptr(dx), *queue, *flag );
}

#define magmablasf_zgemv FORTRAN_NAME( magmablasf_zgemv, MAGMABLASF_ZGEMV )
void magmablasf_zgemv(
    const char* trans, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_zgemv(
        magma_trans_const(*trans), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmablasf_zgemv_conj FORTRAN_NAME( magmablasf_zgemv_conj, MAGMABLASF_ZGEMV_CONJ )
void magmablasf_zgemv_conj(
    magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_zgemv_conj(
        *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmablasf_zhemv FORTRAN_NAME( magmablasf_zhemv, MAGMABLASF_ZHEMV )
magma_int_t magmablasf_zhemv(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magmablas_zhemv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmablasf_zsymv FORTRAN_NAME( magmablasf_zsymv, MAGMABLASF_ZSYMV )
magma_int_t magmablasf_zsymv(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magmablas_zsymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmablasf_zhemv_work FORTRAN_NAME( magmablasf_zhemv_work, MAGMABLASF_ZHEMV_WORK )
magma_int_t magmablasf_zhemv_work(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_zhemv_work(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dwork), *lwork, *queue );
}

#define magmablasf_zsymv_work FORTRAN_NAME( magmablasf_zsymv_work, MAGMABLASF_ZSYMV_WORK )
magma_int_t magmablasf_zsymv_work(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_zsymv_work(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dwork), *lwork, *queue );
}

#define magmablasf_zgemm FORTRAN_NAME( magmablasf_zgemm, MAGMABLASF_ZGEMM )
void magmablasf_zgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_zgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmablasf_zgemm_reduce FORTRAN_NAME( magmablasf_zgemm_reduce, MAGMABLASF_ZGEMM_REDUCE )
void magmablasf_zgemm_reduce(
    magma_int_t *m, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_zgemm_reduce(
        *m, *n, *k, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmablasf_ztrsm FORTRAN_NAME( magmablasf_ztrsm, MAGMABLASF_ZTRSM )
void magmablasf_ztrsm(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_ztrsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmablasf_ztrsm_outofplace FORTRAN_NAME( magmablasf_ztrsm_outofplace, MAGMABLASF_ZTRSM_OUTOFPLACE )
void magmablasf_ztrsm_outofplace(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_ztrsm_outofplace(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        magma_zdevptr(dX), *lddx, *flag,
        magma_zdevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmablasf_ztrsm_work FORTRAN_NAME( magmablasf_ztrsm_work, MAGMABLASF_ZTRSM_WORK )
void magmablasf_ztrsm_work(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_ztrsm_work(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        magma_zdevptr(dX), *lddx, *flag,
        magma_zdevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmaf_zsetvector FORTRAN_NAME( magmaf_zsetvector, MAGMAF_ZSETVECTOR )
void magmaf_zsetvector(
    magma_int_t *n,
    magmaDoubleComplex *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zsetvector(
        *n,
        hx_src, *incx,
        magma_zdevptr(dy_dst), *incy, *queue );
}

#define magmaf_zgetvector FORTRAN_NAME( magmaf_zgetvector, MAGMAF_ZGETVECTOR )
void magmaf_zgetvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    magmaDoubleComplex *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zgetvector(
        *n,
        magma_zdevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_zcopyvector FORTRAN_NAME( magmaf_zcopyvector, MAGMAF_ZCOPYVECTOR )
void magmaf_zcopyvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zcopyvector(
        *n,
        magma_zdevptr(dx_src), *incx,
        magma_zdevptr(dy_dst), *incy, *queue );
}

#define magmaf_zsetvector_async FORTRAN_NAME( magmaf_zsetvector_async, MAGMAF_ZSETVECTOR_ASYNC )
void magmaf_zsetvector_async(
    magma_int_t *n,
    magmaDoubleComplex *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zsetvector_async(
        *n,
        hx_src, *incx,
        magma_zdevptr(dy_dst), *incy, *queue );
}

#define magmaf_zgetvector_async FORTRAN_NAME( magmaf_zgetvector_async, MAGMAF_ZGETVECTOR_ASYNC )
void magmaf_zgetvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    magmaDoubleComplex *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zgetvector_async(
        *n,
        magma_zdevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_zcopyvector_async FORTRAN_NAME( magmaf_zcopyvector_async, MAGMAF_ZCOPYVECTOR_ASYNC )
void magmaf_zcopyvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zcopyvector_async(
        *n,
        magma_zdevptr(dx_src), *incx,
        magma_zdevptr(dy_dst), *incy, *queue );
}

#define magmaf_zsetmatrix FORTRAN_NAME( magmaf_zsetmatrix, MAGMAF_ZSETMATRIX )
void magmaf_zsetmatrix(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_zsetmatrix(
        *m, *n,
        hA_src, *lda,
        magma_zdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_zgetmatrix FORTRAN_NAME( magmaf_zgetmatrix, MAGMAF_ZGETMATRIX )
void magmaf_zgetmatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    magmaDoubleComplex *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_zgetmatrix(
        *m, *n,
        magma_zdevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_zcopymatrix FORTRAN_NAME( magmaf_zcopymatrix, MAGMAF_ZCOPYMATRIX )
void magmaf_zcopymatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_zcopymatrix(
        *m, *n,
        magma_zdevptr(dA_src), *ldda,
        magma_zdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_zsetmatrix_async FORTRAN_NAME( magmaf_zsetmatrix_async, MAGMAF_ZSETMATRIX_ASYNC )
void magmaf_zsetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_zsetmatrix_async(
        *m, *n,
        hA_src, *lda,
        magma_zdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_zgetmatrix_async FORTRAN_NAME( magmaf_zgetmatrix_async, MAGMAF_ZGETMATRIX_ASYNC )
void magmaf_zgetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    magmaDoubleComplex *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_zgetmatrix_async(
        *m, *n,
        magma_zdevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_zcopymatrix_async FORTRAN_NAME( magmaf_zcopymatrix_async, MAGMAF_ZCOPYMATRIX_ASYNC )
void magmaf_zcopymatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_zcopymatrix_async(
        *m, *n,
        magma_zdevptr(dA_src), *ldda,
        magma_zdevptr(dB_dst), *lddb, *queue );
}

#define magmaf_izamax FORTRAN_NAME( magmaf_izamax, MAGMAF_IZAMAX )
magma_int_t magmaf_izamax(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_izamax(
        *n,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_izamin FORTRAN_NAME( magmaf_izamin, MAGMAF_IZAMIN )
magma_int_t magmaf_izamin(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_izamin(
        *n,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_dzasum FORTRAN_NAME( magmaf_dzasum, MAGMAF_DZASUM )
double magmaf_dzasum(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_dzasum(
        *n,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_zaxpy FORTRAN_NAME( magmaf_zaxpy, MAGMAF_ZAXPY )
void magmaf_zaxpy(
    magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zaxpy(
        *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_zcopy FORTRAN_NAME( magmaf_zcopy, MAGMAF_ZCOPY )
void magmaf_zcopy(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zcopy(
        *n,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_dznrm2 FORTRAN_NAME( magmaf_dznrm2, MAGMAF_DZNRM2 )
double magmaf_dznrm2(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_dznrm2(
        *n,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_zrot FORTRAN_NAME( magmaf_zrot, MAGMAF_ZROT )
void magmaf_zrot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, double *dc, magmaDoubleComplex *ds, magma_queue_t *queue )
{
    magma_zrot(
        *n,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *dc, *ds, *queue );
}

#define magmaf_zdrot FORTRAN_NAME( magmaf_zdrot, MAGMAF_ZDROT )
void magmaf_zdrot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, double *dc, double *ds, magma_queue_t *queue )
{
    magma_zdrot(
        *n,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *dc, *ds, *queue );
}

#define magmaf_zrotg FORTRAN_NAME( magmaf_zrotg, MAGMAF_ZROTG )
void magmaf_zrotg(
    devptr_t *a,
    devptr_t *b,
    devptr_t *c,
    devptr_t *s, magma_queue_t *queue )
{
    magma_zrotg(
        magma_zdevptr(a),
        magma_zdevptr(b),
        magma_ddevptr(c),
        magma_zdevptr(s), *queue );
}

#define magmaf_zscal FORTRAN_NAME( magmaf_zscal, MAGMAF_ZSCAL )
void magmaf_zscal(
    magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_zscal(
        *n, *alpha,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_zdscal FORTRAN_NAME( magmaf_zdscal, MAGMAF_ZDSCAL )
void magmaf_zdscal(
    magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_zdscal(
        *n, *alpha,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_zswap FORTRAN_NAME( magmaf_zswap, MAGMAF_ZSWAP )
void magmaf_zswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zswap(
        *n,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_zgemv FORTRAN_NAME( magmaf_zgemv, MAGMAF_ZGEMV )
void magmaf_zgemv(
    const char* transA, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zgemv(
        magma_trans_const(*transA), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_zgerc FORTRAN_NAME( magmaf_zgerc, MAGMAF_ZGERC )
void magmaf_zgerc(
    magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zgerc(
        *m, *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zgeru FORTRAN_NAME( magmaf_zgeru, MAGMAF_ZGERU )
void magmaf_zgeru(
    magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zgeru(
        *m, *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zhemv FORTRAN_NAME( magmaf_zhemv, MAGMAF_ZHEMV )
void magmaf_zhemv(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zhemv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_zher FORTRAN_NAME( magmaf_zher, MAGMAF_ZHER )
void magmaf_zher(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zher(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zher2 FORTRAN_NAME( magmaf_zher2, MAGMAF_ZHER2 )
void magmaf_zher2(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zher2(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zsymv FORTRAN_NAME( magmaf_zsymv, MAGMAF_ZSYMV )
void magmaf_zsymv(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magmaDoubleComplex *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_zsymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *beta,
        magma_zdevptr(dy), *incy, *queue );
}

#define magmaf_zsyr FORTRAN_NAME( magmaf_zsyr, MAGMAF_ZSYR )
void magmaf_zsyr(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zsyr(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zsyr2 FORTRAN_NAME( magmaf_zsyr2, MAGMAF_ZSYR2 )
void magmaf_zsyr2(
    const char* uplo, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zsyr2(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_zdevptr(dx), *incx,
        magma_zdevptr(dy), *incy,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_ztrmv FORTRAN_NAME( magmaf_ztrmv, MAGMAF_ZTRMV )
void magmaf_ztrmv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_ztrmv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_ztrsv FORTRAN_NAME( magmaf_ztrsv, MAGMAF_ZTRSV )
void magmaf_ztrsv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_ztrsv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dx), *incx, *queue );
}

#define magmaf_zgemm FORTRAN_NAME( magmaf_zgemm, MAGMAF_ZGEMM )
void magmaf_zgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zhemm FORTRAN_NAME( magmaf_zhemm, MAGMAF_ZHEMM )
void magmaf_zhemm(
    const char* side, const char* uplo, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zhemm(
        magma_side_const(*side), magma_uplo_const(*uplo), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zher2k FORTRAN_NAME( magmaf_zher2k, MAGMAF_ZHER2K )
void magmaf_zher2k(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zher2k(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zherk FORTRAN_NAME( magmaf_zherk, MAGMAF_ZHERK )
void magmaf_zherk(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zherk(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_zdevptr(dA), *ldda, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zsymm FORTRAN_NAME( magmaf_zsymm, MAGMAF_ZSYMM )
void magmaf_zsymm(
    const char* side, const char* uplo, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zsymm(
        magma_side_const(*side), magma_uplo_const(*uplo), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zsyr2k FORTRAN_NAME( magmaf_zsyr2k, MAGMAF_ZSYR2K )
void magmaf_zsyr2k(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zsyr2k(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zsyrk FORTRAN_NAME( magmaf_zsyrk, MAGMAF_ZSYRK )
void magmaf_zsyrk(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda, magmaDoubleComplex *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_zsyrk(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_zdevptr(dA), *ldda, *beta,
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_ztrmm FORTRAN_NAME( magmaf_ztrmm, MAGMAF_ZTRMM )
void magmaf_ztrmm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_ztrmm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmaf_ztrsm FORTRAN_NAME( magmaf_ztrsm, MAGMAF_ZTRSM )
void magmaf_ztrsm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_ztrsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb, *queue );
}

#define magmaf_zpotf2_lpout FORTRAN_NAME( magmaf_zpotf2_lpout, MAGMAF_ZPOTF2_LPOUT )
magma_int_t magmaf_zpotf2_lpout(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_zpotf2_lpout(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}

#define magmaf_zpotf2_lpin FORTRAN_NAME( magmaf_zpotf2_lpin, MAGMAF_ZPOTF2_LPIN )
magma_int_t magmaf_zpotf2_lpin(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_zpotf2_lpin(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}


#ifdef __cplusplus
}
#endif
